//------------------------------------------------------------
// Copyright Sandlot Games, 2007
// author: Michael Felice
// file: client_saveobject.cs
// brief:
//    This handles the saving and loading of objects through
//    script, ensuring that the dynamic fields of objects and
//    timers are appropriately saved and initialized on load.
//    This is also used to access source saving and loading.
//------------------------------------------------------------


// SAVING OBJECTS

function clientCmdTaskButtonsInitialize()
{
   // remove any existing task buttons
   slgTaskButtonsInitialize();
}

// this receives and saves a list of client-side objects and notifies
// the server when it is done to continue loading objects or start
// loading the rest of the information
function clientCmdSaveObjectData(%data, %start)
{
   %count = getWordCount(%data);

   // save all of the game objects
   for (%index = 0; %index < %count; %index++)
   {
      %ghostID = getWord(%data, %index);
      %object = ServerConnection.resolveGhostId(%ghostID);
      
      // save the game object
      %object.saveToFile();
   }
   
   if (%start == -1)
   {
      commandToServer('SaveObjectDataDone');
      return;
   }
   
   commandToServer('SaveObjectGroup', %start);
}



// LOADING OBJECTS

// this receives and loads a list of client-side objects and notifies
// the server when it is done to continue loading objects or start
// loading the rest of the information
function clientCmdLoadObjectData(%data, %start)
{
   %count = getWordCount(%data);
   
   // load all of the game objects
   for (%index = 0; %index < %count; %index++)
   {
      %ghostID = getWord(%data, %index);
      %object = ServerConnection.resolveGhostId(%ghostID);
      if (isObject(%object) == false)
      {
         error("Error loading objects on the client: object not found from ghost id");
         return;
      }
      
      // load the game object
      if (%object.loadFromFile() == false)
      {
         error("Problem loading object data: failed to load game object data on client");
         return;
      }
   }
   
   if (%start == -1)
   {   
      commandToServer('LoadObjectDataDone');
      return;
   }
   
   commandToServer('LoadObjectGroup', %start);
}
